/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.quantumdatasdk;

import com.quantumdata.quantumdatasdk.ConfigData;
import com.quantumdata.quantumdatasdk.MainScreen;
import com.quantumdata.quantumdatasdk.QuantumDataSDK;
import com.quantumdata.quantumdatasdk.WebInterface;
import com.quantumdata.quantumdatasdk.WebInterfaceException;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class InstallationScreen
extends JPanel {
    public static final String doneCmd = "DONE";
    public static final String jumpCmd = "JUMPTOMAIN";
    private JProgressBar m_progressBar;
    private JLabel m_txtInstruction;
    private Thread m_netThread;
    private WebInterface m_theWeb;
    private Action m_act;
    private JFrame m_frame;
    public static String m_UpgradeURL;
    public static String m_ZipFilePath;

    public InstallationScreen(ActionListener actionListener, JFrame jFrame) {
        this.m_frame = jFrame;
        this.InitScreen(actionListener);
        this.m_txtInstruction = new JLabel("Downloading Upgrade File from the Quantum Data Website.");
        this.m_act = new AutomaticActionEvent(actionListener);
    }

    protected void finalize() {
        this.m_progressBar = null;
        this.m_txtInstruction = null;
        this.m_frame = null;
    }

    private void InitScreen(ActionListener actionListener) {
        JLabel jLabel = MainScreen.getLabel("SETUP STEP 3: Please wait while installing SDK", 16, 1, true);
        this.m_progressBar = new JProgressBar(0, 100);
        this.m_progressBar.setValue(0);
        int n = 0;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints = MainScreen.createGridBagConstraints(2, 0, n++, 0, 10);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        gridBagConstraints = MainScreen.createGridBagConstraints(2, 0, n++, 0, 10);
        gridBagLayout.setConstraints(this.m_progressBar, gridBagConstraints);
        this.add(this.m_progressBar);
    }

    public void run() {
        this.m_netThread = new Thread(new runGetWebFileThread());
        this.m_netThread.setName("Download QuantumData SDK");
        this.m_netThread.start();
    }

    private void makePath(String string) {
        File file = new File(string);
        File file2 = null;
        file2 = new File(file.getParent());
        if (!file2.exists()) {
            file2.mkdirs();
        }
    }

    protected final void copyInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }

    public class AutomaticActionEvent
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private ActionListener m_listener;

        public AutomaticActionEvent(ActionListener actionListener) {
            this.m_listener = actionListener;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("*** Action triggered ***");
            this.putValue("ActionCommandKey", actionEvent.getActionCommand());
            this.m_listener.actionPerformed(actionEvent);
        }
    }

    class runGetWebFileThread
    implements Runnable {
        public synchronized void run() {
            if (this.noUpgradeNeeded()) {
                return;
            }
            if (!this.downloadUpgrade()) {
                return;
            }
            this.unZip();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean noUpgradeNeeded() {
            block15: {
                ActionEvent actionEvent = new ActionEvent(this, 1001, InstallationScreen.jumpCmd);
                InstallationScreen.this.m_act.setEnabled(true);
                try {
                    InstallationScreen.this.m_theWeb = new WebInterface("http://www.quantumdata.com/support/downloads/SDK/QDSDK_1.0/sdkrelease.php", 0);
                }
                catch (MalformedURLException malformedURLException) {
                    JOptionPane.showMessageDialog(InstallationScreen.this.m_frame, "Bad URL: " + InstallationScreen.this.m_theWeb.getURL(), "Bad URL", 0);
                }
                try {
                    InstallationScreen.this.m_theWeb.checkForUpgrade(InstallationScreen.this.m_frame, InstallationScreen.this.m_txtInstruction);
                    m_UpgradeURL = InstallationScreen.this.m_theWeb.getUpgradeFile();
                    ConfigData.sVersion = InstallationScreen.this.m_theWeb.getUpgradeVersion();
                    System.out.println("Upgrade Link: " + m_UpgradeURL);
                }
                catch (WebInterfaceException webInterfaceException) {
                    boolean bl;
                    block14: {
                        int n;
                        String string;
                        String string2;
                        block16: {
                            string2 = "Error";
                            string = "Error";
                            bl = true;
                            n = 0;
                            int n2 = -1;
                            if (webInterfaceException.getUpgradeStatus() == null) break block16;
                            if (webInterfaceException.getUpgradeStatus().equalsIgnoreCase("SAME_VERSION")) {
                                n2 = JOptionPane.showConfirmDialog(InstallationScreen.this.m_frame, "Your PC currently has the latest version for QuantumDat SDK\nWould you like to continue with the upgrade anyway?", "Same Version", 0);
                                System.out.println("^^^^ Option Value = " + n2);
                                if (n2 != 0) {
                                    InstallationScreen.this.m_act.actionPerformed(actionEvent);
                                    return true;
                                }
                                m_UpgradeURL = InstallationScreen.this.m_theWeb.getUpgradeFile();
                                System.out.println("Upgrade Link: " + m_UpgradeURL);
                                bl = false;
                                break block14;
                            } else if (webInterfaceException.getUpgradeStatus().equalsIgnoreCase("NO_UPGRADE_AVAILABLE")) {
                                string = "No Upgrade Available";
                                string2 = "No Upgrade is Available at this time.\nPlease check again later.";
                                n = -1;
                                JOptionPane.showMessageDialog(InstallationScreen.this.m_frame, string2, string, n);
                                break block14;
                            } else {
                                string = "Error";
                                string2 = webInterfaceException.getWebErrorMessage();
                                n = 0;
                                JOptionPane.showMessageDialog(InstallationScreen.this.m_frame, string2, string, n);
                            }
                            break block14;
                        }
                        if (webInterfaceException.getWebResponseCode() > 0) {
                            string = "Web Error";
                            string2 = "Web Host returned an code of " + webInterfaceException.getWebResponseCode() + "\n" + webInterfaceException.getWebResponseMessage();
                            n = 1;
                            JOptionPane.showMessageDialog(InstallationScreen.this.m_frame, string2, string, n);
                        } else if (webInterfaceException.getUpgradeStatus() == null) {
                            string = "Web Error";
                            string2 = "Error: " + webInterfaceException.getWebResponseMessage();
                            n = 0;
                            JOptionPane.showMessageDialog(InstallationScreen.this.m_frame, string2, string, n);
                        }
                    }
                    if (!bl) break block15;
                    System.out.println("Exiting Installation!");
                    QuantumDataSDK.ExitApp();
                    return bl;
                }
            }
            try {
                Thread.yield();
                Thread.sleep(1000L);
                Thread.yield();
                return false;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return false;
        }

        private boolean downloadUpgrade() {
            try {
                System.out.println("Attempting to download: " + m_UpgradeURL);
                InstallationScreen.this.m_theWeb = new WebInterface(m_UpgradeURL, 1);
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(InstallationScreen.this.m_frame, "Bad URL: " + InstallationScreen.this.m_theWeb.getURL(), "Bad URL", 0);
            }
            try {
                InstallationScreen.this.m_theWeb.downloadUpdate(InstallationScreen.this.m_frame, InstallationScreen.this.m_progressBar, InstallationScreen.this.m_txtInstruction);
            }
            catch (WebInterfaceException webInterfaceException) {
                String string = "Error";
                String string2 = "Error";
                int n = 0;
                if (webInterfaceException.getWebResponseCode() > 0) {
                    string2 = "Web Error";
                    string = "Web Host returned an code of " + webInterfaceException.getWebResponseCode() + "\n" + webInterfaceException.getWebResponseMessage();
                    n = 1;
                }
                JOptionPane.showMessageDialog(InstallationScreen.this.m_frame, string, string2, n);
                System.out.println("Exiting");
                QuantumDataSDK.ExitApp();
                return false;
            }
            Thread.yield();
            return true;
        }

        private void unZip() {
            ActionEvent actionEvent = new ActionEvent(this, 1001, InstallationScreen.doneCmd);
            InstallationScreen.this.m_txtInstruction.setText("Extracting the Upgrade files");
            String string = "";
            int n = 0;
            try {
                ZipFile zipFile = new ZipFile(m_ZipFilePath);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                n = 0;
                InstallationScreen.this.m_progressBar.setValue(n);
                InstallationScreen.this.m_progressBar.setMaximum(zipFile.size());
                while (enumeration.hasMoreElements()) {
                    String string2;
                    ZipEntry zipEntry = enumeration.nextElement();
                    ++n;
                    if (zipEntry.isDirectory()) {
                        string = "Extracting directory: " + zipEntry.getName();
                        System.out.println(string);
                        InstallationScreen.this.m_txtInstruction.setText(string);
                        InstallationScreen.this.m_progressBar.setValue(n);
                        string2 = ConfigData.sSDKLocation + "/" + zipEntry.getName();
                        new File(string2).mkdirs();
                        continue;
                    }
                    string = "Extracting file: " + zipEntry.getName();
                    System.out.println(string);
                    InstallationScreen.this.m_txtInstruction.setText(string);
                    InstallationScreen.this.m_progressBar.setValue(n);
                    string2 = ConfigData.sSDKLocation + "/" + zipEntry.getName();
                    InstallationScreen.this.makePath(string2);
                    InstallationScreen.this.copyInputStream(zipFile.getInputStream(zipEntry), new BufferedOutputStream(new FileOutputStream(string2)));
                    Thread.yield();
                }
                InstallationScreen.this.m_progressBar.setValue(zipFile.size());
                zipFile.close();
                ConfigData.StoreConfig();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(InstallationScreen.this.m_frame, "Zip File " + m_ZipFilePath + " Not Found", "Upgrade File Not Found", 0);
            }
            InstallationScreen.this.m_act.actionPerformed(actionEvent);
        }
    }
}

